package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.DatosEnvioPostalDao;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0469s00ServiceImpl generated by UDA, 24-Feb-2017 11:21:23.
 * 
 * @author UDA
 */

@Service(value = "ab0469s00Service")
public class DatosEnvioPostalServiceImpl implements DatosEnvioPostalService {

	@Autowired()
	private DatosEnvioPostalDao ab0469s00Dao;

	/**
	 * Inserts a single row in the Ab0469s00 table.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *  Ab0469s00
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 * @return the datos envio postal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosEnvioPostal add(DatosEnvioPostal ab0469s00) {
		return this.ab0469s00Dao.add(ab0469s00);
	}

	/**
	 * Updates a single row in the Ab0469s00 table.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *  Ab0469s00
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 * @return the datos envio postal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosEnvioPostal update(DatosEnvioPostal ab0469s00) {
		return this.ab0469s00Dao.update(ab0469s00);
	}
	
	/**
	 * Updates a single row in the Ab0469s00 table.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *  Ab0469s00
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 * @return the datos envio postal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosEnvioPostal updateSituacionEnvio(DatosEnvioPostal ab0469s00) {
		return this.ab0469s00Dao.updateSituacionEnvio(ab0469s00);
	}

	/**
	 * Finds a single row in the Ab0469s00 table.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *  Ab0469s00
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal find(DatosEnvioPostal ab0469s00) {
		return (DatosEnvioPostal) this.ab0469s00Dao.find(ab0469s00);
	}

	/**
	 * Deletes a single row in the Ab0469s00 table.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosEnvioPostal ab0469s00) {
		this.ab0469s00Dao.remove(ab0469s00);
	}

	/**
	 * Finds a list of rows in the Ab0469s00 table.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0469s00>
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<DatosEnvioPostal> findAll(DatosEnvioPostal ab0469s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<DatosEnvioPostal>) this.ab0469s00Dao.findAll(ab0469s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0469s00 table using like.
	 * 
	 *  ab0469s00
	 *            Ab0469s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0469s00>
	 *
	 * @param ab0469s00 the ab 0469 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<DatosEnvioPostal> findAllLike(DatosEnvioPostal ab0469s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<DatosEnvioPostal>) this.ab0469s00Dao.findAllLike(ab0469s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0469s00 table.
	 * 
	 *  filterAb0469s00
	 *            Ab0469s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0469s00>
	 *
	 * @param filterAb0469s00 the filter ab 0469 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<DatosEnvioPostal> filter(
			DatosEnvioPostal filterAb0469s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<DatosEnvioPostal> listaAb0469s00 = this.ab0469s00Dao
				.findAllLike(filterAb0469s00, jqGridRequestDto, false);
		Long recordNum = this.ab0469s00Dao
				.findAllLikeCount(filterAb0469s00 != null ? filterAb0469s00
						: new DatosEnvioPostal(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<DatosEnvioPostal>> reorderSelection = this.ab0469s00Dao
					.reorderSelection(filterAb0469s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<DatosEnvioPostal>(jqGridRequestDto,
					recordNum, listaAb0469s00, reorderSelection);
		}
		return new JQGridResponseDto<DatosEnvioPostal>(jqGridRequestDto,
				recordNum, listaAb0469s00);
	}

	/**
	 * Searches rows in the Ab0469s00 table.
	 * 
	 *  filterAb0469s00
	 *            Ab0469s00
	 *  searchAb0469s00
	 *            Ab0469s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0469s00>>
	 *
	 * @param filterAb0469s00 the filter ab 0469 s 00
	 * @param searchAb0469s00 the search ab 0469 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<DatosEnvioPostal>> search(
			DatosEnvioPostal filterAb0469s00, DatosEnvioPostal searchAb0469s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0469s00Dao.search(filterAb0469s00, searchAb0469s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0469s00 table.
	 * 
	 *  filterAb0469s00
	 *            Ab0469s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0469s00 the filter ab 0469 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(DatosEnvioPostal filterAb0469s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0469s00Dao.reorderSelection(filterAb0469s00,
				jqGridRequestDto, startsWith);
	}

}
